package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 * 
 */

public class RequestHistoryConverterTest extends AbstractMockMvcTests {

	private RequestHistoryConverter requestHistoryConverter;
	private CommentHistoryConverter commentHistoryConverter;

	@Before
	public void setUp() {

		requestHistoryConverter = new RequestHistoryConverter();
		commentHistoryConverter = new CommentHistoryConverter();
		requestHistoryConverter.setCommentHistoryConverter(commentHistoryConverter);
	}

	@Test
	public void convert() {
		RequestHistory requestHistory = Helper.getNewRequestHistory();
		assertEquals("Postman Sample Create Request - Updated", requestHistoryConverter.convert(requestHistory).getTitle());
		assertNotSame("Postman Sample Create Request", requestHistoryConverter.convert(requestHistory).getTitle());
	}

	@Test
	public void convert2() {

		assertEquals("Postman Sample Create Request - Updated", requestHistoryConverter.convert(Helper.getRequestHistoryDTO()).getTitle());
		assertNotSame("Postman Sample Create Request", requestHistoryConverter.convert(Helper.getRequestHistoryDTO()).getTitle());

	}

	@Test
	public void convertRequestHistories() {
		Set<RequestHistory> requestHistories = new HashSet<>();
		requestHistories.add(Helper.getNewRequestHistory());

		assertTrue(!requestHistoryConverter.convertRequestHistories(requestHistories).isEmpty());
		assertFalse(requestHistoryConverter.convertRequestHistories(requestHistories).isEmpty());
	}

	@Test
	public void convert3() {

		List<CommentHistory> commentHistories = new ArrayList<>();
		commentHistories.add(Helper.getCommentHistory());
		assertEquals("This is a sample new request for demo purposes - updated", requestHistoryConverter.convert(Helper.getNewRequestHistory(), commentHistories).getDescription());
		assertNotSame("Postman Sample Create Request", requestHistoryConverter.convert(Helper.getRequestHistoryDTO()).getDescription());
	}

	@Test
	public void populateRequestHistory() {
		assertEquals("Return", requestHistoryConverter.populateRequestHistory(Helper.getExistingRequest()).getStatusDescription());
		assertNotSame("Draft", requestHistoryConverter.populateRequestHistory(Helper.getExistingRequest()).getStatusDescription());
	}
}
